#!/usr/bin/env python3
import sys, json
from jsonschema import validate, Draft202012Validator

def main(manifest_path, schema_path):
    with open(manifest_path, 'r', encoding='utf-8') as f:
        manifest = json.load(f)
    with open(schema_path, 'r', encoding='utf-8') as f:
        schema = json.load(f)

    v = Draft202012Validator(schema)
    errors = sorted(v.iter_errors(manifest), key=lambda e: e.path)
    if errors:
        for e in errors:
            print(f"[SCHEMA] {list(e.path)}: {e.message}")
        sys.exit(1)
    print("[OK] Manifest conforms to schema.")

if __name__ == "__main__":
    if len(sys.argv) != 3:
        print("Usage: validate_manifest.py <manifest.json> <manifest.schema.json>")
        sys.exit(2)
    main(sys.argv[1], sys.argv[2])
